/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.ModifyVetoException;
import org.jaudiotagger.audio.generic.AudioFileModificationListener;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;

public abstract class AudioFileWriter {
    private static final String TEMP_FILENAME_SUFFIX = ".tmp";
    private static final String WRITE_MODE = "rws";
    private static final int MINIMUM_FILESIZE = 150;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic");
    private static final String FILE_NAME_TOO_LONG = "File name too long";
    private static final String FILE_NAME_TOO_LONG2 = "The filename, directory name, or volume label syntax is incorrect";
    private static final int FILE_NAME_TOO_LONG_SAFE_LIMIT = 50;
    private AudioFileModificationListener modificationListener = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(AudioFile af) throws CannotReadException, CannotWriteException {
        File result;
        block29: {
            if (!af.getFile().canWrite()) {
                throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(af.getFile().getPath()));
            }
            if (af.getFile().length() <= 150L) {
                throw new CannotWriteException(ErrorMessage.GENERAL_DELETE_FAILED.getMsg(af.getFile().getPath()));
            }
            RandomAccessFile raf = null;
            RandomAccessFile rafTemp = null;
            File tempF = null;
            boolean revert = false;
            try {
                tempF = File.createTempFile(af.getFile().getName().replace('.', '_'), TEMP_FILENAME_SUFFIX, af.getFile().getParentFile());
                rafTemp = new RandomAccessFile(tempF, WRITE_MODE);
                raf = new RandomAccessFile(af.getFile(), WRITE_MODE);
                raf.seek(0L);
                rafTemp.seek(0L);
                try {
                    if (this.modificationListener != null) {
                        this.modificationListener.fileWillBeModified(af, true);
                    }
                    this.deleteTag(raf, rafTemp);
                    if (this.modificationListener != null) {
                        this.modificationListener.fileModified(af, tempF);
                    }
                }
                catch (ModifyVetoException veto) {
                    throw new CannotWriteException(veto);
                }
                result = af.getFile();
            }
            catch (Exception e) {
                try {
                    revert = true;
                    throw new CannotWriteException("\"" + af.getFile().getAbsolutePath() + "\" :" + e, e);
                }
                catch (Throwable throwable) {
                    File result2;
                    block28: {
                        result2 = af.getFile();
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                            if (rafTemp != null) {
                                rafTemp.close();
                            }
                            if (tempF.length() > 0L && !revert) {
                                boolean deleteResult = af.getFile().delete();
                                if (!deleteResult) {
                                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                                }
                                boolean renameResult = tempF.renameTo(af.getFile());
                                if (!renameResult) {
                                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                                }
                                result2 = tempF;
                                if (tempF.exists() && !tempF.delete()) {
                                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(tempF.getPath()));
                                }
                                break block28;
                            }
                            if (!tempF.delete()) {
                                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(tempF.getPath()));
                            }
                        }
                        catch (Exception ex) {
                            logger.severe("AudioFileWriter exception cleaning up delete:" + af.getFile().getPath() + " or" + tempF.getAbsolutePath() + ":" + ex);
                        }
                    }
                    if (this.modificationListener == null) throw throwable;
                    this.modificationListener.fileOperationFinished(result2);
                    throw throwable;
                }
            }
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
                if (tempF.length() > 0L && !revert) {
                    boolean deleteResult = af.getFile().delete();
                    if (!deleteResult) {
                        logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                        throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                    }
                    boolean renameResult = tempF.renameTo(af.getFile());
                    if (!renameResult) {
                        logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                        throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getPath(), tempF.getPath()));
                    }
                    result = tempF;
                    if (tempF.exists() && !tempF.delete()) {
                        logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(tempF.getPath()));
                    }
                    break block29;
                }
                if (!tempF.delete()) {
                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(tempF.getPath()));
                }
            }
            catch (Exception ex) {
                logger.severe("AudioFileWriter exception cleaning up delete:" + af.getFile().getPath() + " or" + tempF.getAbsolutePath() + ":" + ex);
            }
        }
        if (this.modificationListener == null) return;
        this.modificationListener.fileOperationFinished(result);
    }

    public void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotReadException, CannotWriteException, IOException {
        raf.seek(0L);
        tempRaf.seek(0L);
        this.deleteTag(raf, tempRaf);
    }

    protected abstract void deleteTag(RandomAccessFile var1, RandomAccessFile var2) throws CannotReadException, CannotWriteException, IOException;

    public void setAudioFileModificationListener(AudioFileModificationListener listener) {
        this.modificationListener = listener;
    }

    private void precheckWrite(AudioFile af) throws CannotWriteException {
        try {
            if (af.getTag().isEmpty()) {
                this.delete(af);
                return;
            }
        }
        catch (CannotReadException re) {
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(af.getFile().getPath()));
        }
        if (!af.getFile().canWrite()) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(af.getFile().getPath()));
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(af.getFile().getPath()));
        }
        if (af.getFile().length() <= 150L) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(af.getFile().getPath()));
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(af.getFile().getPath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(AudioFile af) throws CannotWriteException {
        File newFile;
        logger.config("Started writing tag data for file:" + af.getFile().getName());
        this.precheckWrite(af);
        if (af instanceof MP3File) {
            af.commit();
            return;
        }
        RandomAccessFile raf = null;
        RandomAccessFile rafTemp = null;
        try {
            newFile = File.createTempFile(af.getFile().getName().replace('.', '_'), TEMP_FILENAME_SUFFIX, af.getFile().getParentFile());
        }
        catch (IOException ioe) {
            if (ioe.getMessage().equals(FILE_NAME_TOO_LONG) && af.getFile().getName().length() > 50) {
                try {
                    newFile = File.createTempFile(af.getFile().getName().substring(0, 50).replace('.', '_'), TEMP_FILENAME_SUFFIX, af.getFile().getParentFile());
                }
                catch (IOException ioe2) {
                    logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(af.getFile().getName(), af.getFile().getParentFile().getAbsolutePath()), ioe2);
                    throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(af.getFile().getName(), af.getFile().getParentFile().getAbsolutePath()));
                }
            }
            logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(af.getFile().getName(), af.getFile().getParentFile().getAbsolutePath()), ioe);
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(af.getFile().getName(), af.getFile().getParentFile().getAbsolutePath()));
        }
        try {
            rafTemp = new RandomAccessFile(newFile, WRITE_MODE);
            raf = new RandomAccessFile(af.getFile(), WRITE_MODE);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(af.getFile().getAbsolutePath()), ioe);
            try {
                if (raf != null) {
                    raf.close();
                }
                if (rafTemp != null) {
                    rafTemp.close();
                }
            }
            catch (IOException ioe2) {
                logger.log(Level.WARNING, ErrorMessage.GENERAL_WRITE_PROBLEM_CLOSING_FILE_HANDLE.getMsg(af.getFile(), ioe.getMessage()), ioe2);
            }
            if (!newFile.delete()) {
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(newFile.getAbsolutePath()));
            }
            throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(af.getFile().getAbsolutePath()));
        }
        try {
            raf.seek(0L);
            rafTemp.seek(0L);
            try {
                if (this.modificationListener != null) {
                    this.modificationListener.fileWillBeModified(af, false);
                }
                this.writeTag(af.getTag(), raf, rafTemp);
                if (this.modificationListener != null) {
                    this.modificationListener.fileModified(af, newFile);
                }
            }
            catch (ModifyVetoException veto) {
                throw new CannotWriteException(veto);
            }
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE.getMsg(af.getFile(), e.getMessage()), e);
                try {
                    if (raf != null) {
                        raf.close();
                    }
                    if (rafTemp != null) {
                        rafTemp.close();
                    }
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, ErrorMessage.GENERAL_WRITE_PROBLEM_CLOSING_FILE_HANDLE.getMsg(af.getFile().getAbsolutePath(), ioe.getMessage()), ioe);
                }
                if (!newFile.delete()) {
                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(newFile.getAbsolutePath()));
                }
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE.getMsg(af.getFile(), e.getMessage()));
            }
            catch (Throwable throwable) {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                    if (rafTemp == null) throw throwable;
                    rafTemp.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, ErrorMessage.GENERAL_WRITE_PROBLEM_CLOSING_FILE_HANDLE.getMsg(af.getFile().getAbsolutePath(), ioe.getMessage()), ioe);
                }
                throw throwable;
            }
        }
        try {
            if (raf != null) {
                raf.close();
            }
            if (rafTemp != null) {
                rafTemp.close();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ErrorMessage.GENERAL_WRITE_PROBLEM_CLOSING_FILE_HANDLE.getMsg(af.getFile().getAbsolutePath(), ioe.getMessage()), ioe);
        }
        File result = af.getFile();
        if (newFile.length() > 0L) {
            File originalFileBackup = new File(af.getFile().getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(af.getFile()) + ".old");
            int count = 1;
            while (originalFileBackup.exists()) {
                originalFileBackup = new File(af.getFile().getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(af.getFile()) + ".old" + count);
                ++count;
            }
            boolean renameResult = Utils.rename(af.getFile(), originalFileBackup);
            if (!renameResult) {
                logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(af.getFile().getAbsolutePath(), originalFileBackup.getName()));
                if (newFile != null) {
                    newFile.delete();
                }
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(af.getFile().getPath(), originalFileBackup.getName()));
            }
            renameResult = Utils.rename(newFile, af.getFile());
            if (!renameResult) {
                if (!newFile.exists()) {
                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_NEW_FILE_DOESNT_EXIST.getMsg(newFile.getAbsolutePath()));
                }
                if (!originalFileBackup.renameTo(af.getFile())) {
                    logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_BACKUP_TO_ORIGINAL.getMsg(originalFileBackup.getAbsolutePath(), af.getFile().getName()));
                }
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getAbsolutePath(), newFile.getName()));
                throw new CannotWriteException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(af.getFile().getAbsolutePath(), newFile.getName()));
            }
            boolean deleteResult = originalFileBackup.delete();
            if (!deleteResult) {
                logger.warning(ErrorMessage.GENERAL_WRITE_WARNING_UNABLE_TO_DELETE_BACKUP_FILE.getMsg(originalFileBackup.getAbsolutePath()));
            }
            if (newFile.exists() && !newFile.delete()) {
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(newFile.getPath()));
            }
        } else if (!newFile.delete()) {
            logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_DELETE_TEMPORARY_FILE.getMsg(newFile.getPath()));
        }
        if (this.modificationListener == null) return;
        this.modificationListener.fileOperationFinished(result);
    }

    protected abstract void writeTag(Tag var1, RandomAccessFile var2, RandomAccessFile var3) throws CannotReadException, CannotWriteException, IOException;
}

